/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.api.dataexchange.handler.autosync;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import net.minecraft.class_2540;
import ru.bclib.BCLib;
import ru.bclib.api.dataexchange.DataHandler;
import ru.bclib.api.dataexchange.SyncFileHash;
import ru.bclib.api.dataexchange.handler.autosync.AutoSync;
import ru.bclib.api.dataexchange.handler.autosync.AutoSyncID;
import ru.bclib.api.dataexchange.handler.autosync.SyncFolderDescriptor;
import ru.bclib.util.ModUtil;
import ru.bclib.util.Pair;
import ru.bclib.util.PathUtil;
import ru.bclib.util.Triple;

class AutoFileSyncEntry
extends AutoSyncID {
    public final AutoSync.NeedTransferPredicate needTransfer;
    public final File fileName;
    public final boolean requestContent;
    private SyncFileHash hash;

    AutoFileSyncEntry(String modID, File fileName, boolean requestContent, AutoSync.NeedTransferPredicate needTransfer) {
        this(modID, fileName.getName(), fileName, requestContent, needTransfer);
    }

    AutoFileSyncEntry(String modID, String uniqueID, File fileName, boolean requestContent, AutoSync.NeedTransferPredicate needTransfer) {
        super(modID, uniqueID);
        this.needTransfer = needTransfer;
        this.fileName = fileName;
        this.requestContent = requestContent;
    }

    public SyncFileHash getFileHash() {
        if (this.hash == null) {
            this.hash = SyncFileHash.create(this.modID, this.fileName, this.uniqueID);
        }
        return this.hash;
    }

    public byte[] getContent() {
        if (!this.fileName.exists()) {
            return new byte[0];
        }
        Path path = this.fileName.toPath();
        try {
            return Files.readAllBytes(path);
        }
        catch (IOException iOException) {
            return new byte[0];
        }
    }

    public int serializeContent(class_2540 buf) {
        DataHandler.writeString(buf, this.modID);
        DataHandler.writeString(buf, this.uniqueID);
        return this.serializeFileContent(buf);
    }

    public static Triple<AutoFileSyncEntry, byte[], AutoSyncID> deserializeContent(class_2540 buf) {
        String modID = DataHandler.readString(buf);
        String uniqueID = DataHandler.readString(buf);
        byte[] data = AutoFileSyncEntry.deserializeFileContent(buf);
        AutoFileSyncEntry entry = "bclib::FILE".equals(modID) ? ForDirectFileRequest.finishDeserializeContent(uniqueID, buf) : ("bclib::MOD".equals(uniqueID) ? ForModFileRequest.finishDeserializeContent(modID, buf) : AutoFileSyncEntry.findMatching(modID, uniqueID));
        return new Triple<AutoFileSyncEntry, byte[], AutoSyncID>(entry, data, new AutoSyncID(modID, uniqueID));
    }

    public void serialize(class_2540 buf) {
        this.getFileHash().serialize(buf);
        buf.writeBoolean(this.requestContent);
        if (this.requestContent) {
            this.serializeFileContent(buf);
        }
    }

    public static AutoSync.AutoSyncTriple deserializeAndMatch(class_2540 buf) {
        Pair<SyncFileHash, byte[]> e = AutoFileSyncEntry.deserialize(buf);
        AutoFileSyncEntry match = AutoFileSyncEntry.findMatching((SyncFileHash)e.first);
        return new AutoSync.AutoSyncTriple((SyncFileHash)e.first, (byte[])e.second, match);
    }

    public static Pair<SyncFileHash, byte[]> deserialize(class_2540 buf) {
        SyncFileHash hash = SyncFileHash.deserialize(buf);
        boolean withContent = buf.readBoolean();
        byte[] data = null;
        if (withContent) {
            data = AutoFileSyncEntry.deserializeFileContent(buf);
        }
        return new Pair<SyncFileHash, byte[]>(hash, data);
    }

    private int serializeFileContent(class_2540 buf) {
        if (!PathUtil.isChildOf(PathUtil.GAME_FOLDER, this.fileName.toPath())) {
            BCLib.LOGGER.error(this.fileName + " is not within game folder " + PathUtil.GAME_FOLDER + ". Pretending it does not exist.");
            buf.writeInt(0);
            return 0;
        }
        byte[] content = this.getContent();
        buf.writeInt(content.length);
        buf.method_10813(content);
        return content.length;
    }

    private static byte[] deserializeFileContent(class_2540 buf) {
        int size = buf.readInt();
        byte[] data = buf.method_10803(size);
        return data;
    }

    public static AutoFileSyncEntry findMatching(SyncFileHash hash) {
        return AutoFileSyncEntry.findMatching(hash.modID, hash.uniqueID);
    }

    public static AutoFileSyncEntry findMatching(AutoSyncID aid) {
        if (aid instanceof AutoSyncID.ForDirectFileRequest) {
            SyncFolderDescriptor.SubFile subFile;
            AutoSyncID.ForDirectFileRequest freq = (AutoSyncID.ForDirectFileRequest)aid;
            SyncFolderDescriptor desc = AutoSync.getSyncFolderDescriptor(freq.uniqueID);
            if (desc != null && (subFile = desc.getLocalSubFile(freq.relFile.toString())) != null) {
                File absPath = desc.localFolder.resolve(subFile.relPath).normalize().toFile();
                return new ForDirectFileRequest(freq.uniqueID, new File(subFile.relPath), absPath);
            }
            return null;
        }
        if (aid instanceof AutoSyncID.ForModFileRequest) {
            AutoSyncID.ForModFileRequest mreq = (AutoSyncID.ForModFileRequest)aid;
            return new ForModFileRequest(mreq.modID, true, null);
        }
        return AutoFileSyncEntry.findMatching(aid.modID, aid.uniqueID);
    }

    public static AutoFileSyncEntry findMatching(String modID, String uniqueID) {
        return AutoSync.getAutoSyncFiles().stream().filter(asf -> asf.modID.equals(modID) && asf.uniqueID.equals(uniqueID)).findFirst().orElse(null);
    }

    static class ForDirectFileRequest
    extends AutoFileSyncEntry {
        final File relFile;

        ForDirectFileRequest(String syncID, File relFile, File absFile) {
            super("bclib::FILE", syncID, absFile, false, (a, b, c) -> false);
            this.relFile = relFile;
        }

        @Override
        public int serializeContent(class_2540 buf) {
            int res = super.serializeContent(buf);
            DataHandler.writeString(buf, this.relFile.toString());
            return res;
        }

        static ForDirectFileRequest finishDeserializeContent(String syncID, class_2540 buf) {
            String relFile = DataHandler.readString(buf);
            SyncFolderDescriptor desc = AutoSync.getSyncFolderDescriptor(syncID);
            if (desc != null && desc.acceptChildElements(desc.mapAbsolute(relFile))) {
                return new ForDirectFileRequest(syncID, new File(relFile), desc.localFolder.resolve(relFile).normalize().toFile());
            }
            return null;
        }

        @Override
        public String toString() {
            return this.uniqueID + " - " + this.relFile;
        }
    }

    static class ForModFileRequest
    extends AutoFileSyncEntry {
        public final String version;

        public static File getLocalPathForID(String modID, boolean matchLocalVersion) {
            ModUtil.ModInfo mi = ModUtil.getModInfo(modID, matchLocalVersion);
            if (mi != null) {
                return mi.jarPath.toFile();
            }
            return null;
        }

        ForModFileRequest(String modID, boolean matchLocalVersion, String version) {
            super(modID, "bclib::MOD", ForModFileRequest.getLocalPathForID(modID, matchLocalVersion), false, (a, b, c) -> false);
            if (this.fileName == null && matchLocalVersion) {
                BCLib.LOGGER.error("Unknown mod '" + modID + "'.");
            }
            this.version = version == null ? ModUtil.getModVersion(modID) : version;
        }

        @Override
        public int serializeContent(class_2540 buf) {
            int res = super.serializeContent(buf);
            buf.writeInt(ModUtil.convertModVersion(this.version));
            return res;
        }

        static ForModFileRequest finishDeserializeContent(String modID, class_2540 buf) {
            String version = ModUtil.convertModVersion(buf.readInt());
            return new ForModFileRequest(modID, false, version);
        }

        @Override
        public String toString() {
            return "Mod " + this.modID + " (v" + this.version + ")";
        }
    }
}

